VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "tabctl32.ocx"
Object = "{69323D51-F7F9-42C2-9A46-10D70F07428B}#4.0#0"; "NDISLIKDA5.dll"
Begin VB.Form frmMain 
   Caption         =   "SLIK-DA Simple Server"
   ClientHeight    =   6270
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   9285
   LinkTopic       =   "Form1"
   ScaleHeight     =   6270
   ScaleWidth      =   9285
   Begin VB.Timer tmrTagUpdate 
      Interval        =   1000
      Left            =   720
      Top             =   0
   End
   Begin VB.Timer tmrMain 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   1560
      Top             =   0
   End
   Begin VB.Frame fraDescription 
      Height          =   1455
      Left            =   0
      TabIndex        =   1
      Top             =   4800
      Width           =   9255
      Begin VB.Image imgLogo 
         BorderStyle     =   1  'Fixed Single
         Height          =   1050
         Left            =   120
         Picture         =   "frmMain.frx":0000
         Top             =   240
         Width           =   1560
      End
      Begin VB.Image imgCert 
         BorderStyle     =   1  'Fixed Single
         Height          =   1050
         Left            =   7560
         Picture         =   "frmMain.frx":2763
         Stretch         =   -1  'True
         Top             =   240
         Width           =   1560
      End
      Begin VB.Label lblDescription 
         Caption         =   $"frmMain.frx":31CC
         Height          =   975
         Left            =   1800
         TabIndex        =   2
         Top             =   300
         Width           =   5625
      End
   End
   Begin TabDlg.SSTab tabMain 
      Height          =   3975
      Left            =   120
      TabIndex        =   0
      Top             =   720
      Width           =   9015
      _ExtentX        =   15901
      _ExtentY        =   7011
      _Version        =   393216
      Style           =   1
      Tabs            =   2
      TabsPerRow      =   5
      TabHeight       =   520
      TabCaption(0)   =   "Statistics"
      TabPicture(0)   =   "frmMain.frx":32ED
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "lvStats"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).ControlCount=   1
      TabCaption(1)   =   "Trace Messages"
      TabPicture(1)   =   "frmMain.frx":3309
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "txtTraceMsgs"
      Tab(1).ControlCount=   1
      Begin MSComctlLib.ListView lvStats 
         Height          =   3615
         Left            =   50
         TabIndex        =   3
         Top             =   360
         Width           =   8775
         _ExtentX        =   15478
         _ExtentY        =   6376
         View            =   3
         LabelWrap       =   -1  'True
         HideSelection   =   -1  'True
         FullRowSelect   =   -1  'True
         GridLines       =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   2
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Statistic"
            Object.Width           =   7620
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Value"
            Object.Width           =   2540
         EndProperty
      End
      Begin VB.TextBox txtTraceMsgs 
         Height          =   3255
         Left            =   -74950
         MultiLine       =   -1  'True
         OLEDragMode     =   1  'Automatic
         ScrollBars      =   3  'Both
         TabIndex        =   4
         Top             =   360
         Width           =   7575
      End
   End
   Begin NDISLIKDACtl.SLIKServer SLIKServer1 
      Left            =   120
      Top             =   0
      _cx             =   847
      _cy             =   847
      ProgID          =   "NDI.VBSimpleSvr.1"
      CLSID           =   "{3214F07D-63C6-441B-8557-06F9764140D6}"
      AppID           =   "{3214F07D-63C6-441B-8557-06F9764140D6}"
      AppName         =   "VB Simple Server"
      Description     =   "VB Simple Server using SlIK-DA"
      VendorName      =   "Northern Dynamic Inc."
      MaxUpdateRate   =   50
      StatsSamplePeriod=   1000
      UseBuiltinBrowser=   -1
      COMCallTracingEnabled=   0
      ServerStatus    =   5
      SecurityGranularity=   0
      SecurityPrivateEnabled=   0
      SecurityNTEnabled=   0
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileClientDisc 
         Caption         =   "&Request Clients To Disconnect"
      End
      Begin VB.Menu mnuFileSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileForceExit 
         Caption         =   "&Force Server Exit"
      End
      Begin VB.Menu mnuFileSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuEditStatPeriod 
         Caption         =   "Statistics Sample &Period ..."
      End
   End
   Begin VB.Menu mnuTrace 
      Caption         =   "&Trace"
      Begin VB.Menu mnuTraceNone 
         Caption         =   "&None"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuTraceConnect 
         Caption         =   "&Connect"
      End
      Begin VB.Menu mnuTraceGroup 
         Caption         =   "&Group"
      End
      Begin VB.Menu mnuTraceItem 
         Caption         =   "&Item"
      End
      Begin VB.Menu mnuTraceAll 
         Caption         =   "&All"
      End
      Begin VB.Menu mnuTraceSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTraceClear 
         Caption         =   "C&lear Messages"
      End
      Begin VB.Menu mnuTraceSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuTraceCOM 
         Caption         =   "&Enable COM Call Tracing"
      End
   End
   Begin VB.Menu mnuSecurity 
      Caption         =   "&Security"
      Begin VB.Menu mnuSecPriv 
         Caption         =   "Enbale Private"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About ..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'********************************************************************************
'
'                       C O P Y R I G H T  (c) 2002
'               N O R T H E R N    D Y N A M I C   I N C.
'                           All Rights Reserved.
'   ........................................................................
'   This sample code is provided by Northern Dynamic solely to assist in
'   understanding the use of the SLIK-DA ActiveX Control. This code is
'   provided as-is and without warranty or support of any sort.
'
'********************************************************************************
'
'   Project:        SLIK-DA ActiveX Control
'
'   Description:    This sample server application is based on Northern Dynamic's
'                   Simple Language Independent Toolkit for creating OPC
'                   Data Access servers (SLIK-DA). This implementation illustrates
'                   the use of various features of the SLIK-DA ActiveX Control.
'
'   Revision:
'       02-03-27    gmg     Initial release.
'       04-09-30    gde     Modified for DA V3.00 support
'       04-12-09    gde     Modified to add OPC Private security support
'
'********************************************************************************
Option Explicit

Public m_sAppName As String

' Maximum size (in characters) of all messages in the Trace Window.
Private Const c_nMaxTraceViewLen As Long = 30000

' Flag indicating message destination for ReportEvent method. Set this flag as
' follows:
'   True - Display message in popup dialog.
'   False - Log message to trace window. Use this setting to prevent popup dialogs
'       when running the server in the background.
Private Const c_bUseMsgBox As Boolean = True

' Flag indicating whether the 'Force Server Exit' option has been selected
Private m_bForceExit As Boolean

' Define a simple security database.  A real server
' would use something refined than this.
Private Type SecDBType
    UserName As String
    Password As String
    AccessGranted As Long
End Type
Private m_SecDB(1 To 3) As SecDBType

'********************************************************************************
' Description:      Log a debug message to the trace window.
'
' Parameters:
'   In:             sMsg  The debug message.
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub LogDebugMessage(ByRef sMsg As String)

    Call LogTraceMessage("DEBUG (" & sMsg & ")")

End Sub

'********************************************************************************
' Description:      Log a message to the trace window.
'
' Parameters:
'   In:             sMsg  The trace message.
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub LogTraceMessage(ByRef sMsg As String)

    '
    ' Format the message for the trace window.
    '
    Dim sTemp As String
    sTemp = Format(Now(), "hh:mm:ss") & " " & sMsg & vbNewLine
    
    If (Len(txtTraceMsgs.Text) > c_nMaxTraceViewLen) Then
        '
        '  Make room for more messages
        '
        Dim nPos As Long
        nPos = InStr(c_nMaxTraceViewLen * 0.25, txtTraceMsgs.Text, vbNewLine, vbTextCompare)
        If nPos > 0 Then
            txtTraceMsgs.Text = Mid(txtTraceMsgs.Text, nPos + 2)
        End If
    End If
    
    '
    ' Append message in the trace window
    '
    txtTraceMsgs.SelStart = Len(txtTraceMsgs.Text)
    txtTraceMsgs.SelText = sTemp

End Sub

'********************************************************************************
' Description:      Either display a message box for the given message, or log the
'                   message to the trace window.
'
' Parameters:
'   In:             sMsg  The trace message.
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Public Sub ReportEvent(ByRef sPrompt As String, ByRef sTitle As String)

    If c_bUseMsgBox Then
        Call MsgBox(sPrompt, vbOKOnly, sTitle)
    Else
        Call LogDebugMessage(sTitle & ": " & sPrompt)
    End If

End Sub


'********************************************************************************
' Description:      Initialize the statistics window with the list of server
'                   statistics. Create a entry (row) for each statistic.
'
' Parameters:
'   In:             None
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub InitializeStatsView()

    lvStats.ListItems.Add c_nStatSamplePeriod, , "Sample Period (ms)"
    lvStats.ListItems.Add c_nStatClients, , "Number of Clients"
    lvStats.ListItems.Add c_nStatGroups, , "Number of Groups"
    lvStats.ListItems.Add c_nStatItems, , "Number of Items"
    lvStats.ListItems.Add c_nStatReads, , "Number of Reads (last sample period)"
    lvStats.ListItems.Add c_nStatWrites, , "Number of Writes (last sample period)"
    lvStats.ListItems.Add c_nStatChanges, , "Number of Change Notifications (last sample period)"
    lvStats.ListItems.Add c_nStatLogons, , "Number of Users Logged On"
    
    Call UpdateStatsView

End Sub

'********************************************************************************
' Description:      Update the statistics window with the current value of each
'                   server statistic.
'
' Parameters:
'   In:             None
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub UpdateStatsView()

    On Error GoTo errHandler

    Dim Stats As NDISLIKDACtl.ISLIKStatistics
    Set Stats = SLIKServer1.SLIKStatistics
    
    '
    ' Note: Use either numeric or string constants (see module mdlSLIK) to
    ' reference each statistic.
    '
    lvStats.ListItems(c_nStatSamplePeriod).SubItems(1) = Stats.Item(sdaSamplePeriod)
    lvStats.ListItems(c_nStatClients).SubItems(1) = Stats.Item(sdaNumClients)
    lvStats.ListItems(c_nStatGroups).SubItems(1) = Stats.Item(sdaNumGroups)
    lvStats.ListItems(c_nStatItems).SubItems(1) = Stats.Item(sdaNumItems)
    lvStats.ListItems(c_nStatReads).SubItems(1) = Stats.Item(sdaNumReadsPerPeriod)
    lvStats.ListItems(c_nStatWrites).SubItems(1) = Stats.Item(sdaNumWritesPerPeriod)
    lvStats.ListItems(c_nStatChanges).SubItems(1) = Stats.Item(sdaNumChgPerPeriod)
    lvStats.ListItems(c_nStatLogons).SubItems(1) = Stats.Item(sdaNumLogons)
    
    ' Alternative method:
    'Dim nIndex As Integer
    'nIndex = 1
    'Dim varStat As Variant
    'For Each varStat In Stats
    '    lvStats.ListItems(nIndex).SubItems(1) = varStat
    '    nIndex = nIndex + 1
    'Next varStat

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Update Statistics View Error")

End Sub

'********************************************************************************
' Description:      Update the main menu tracing options, so that only one option
'                   is selected (checked).
'
' Parameters:
'   In:             TraceLevel  The user-selected trace level.
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub UpdateTraceOptions(ByVal TraceLevel As NDISLIKDACtl.TraceLevelEnum)

    mnuTraceNone.Checked = False
    mnuTraceConnect.Checked = False
    mnuTraceGroup.Checked = False
    mnuTraceItem.Checked = False
    mnuTraceAll.Checked = False
    
    If TraceLevel = sdaTraceLevelNone Then
        mnuTraceNone.Checked = True
    ElseIf TraceLevel = sdaTraceLevelConnect Then
        mnuTraceConnect.Checked = True
    ElseIf TraceLevel = sdaTraceLevelGroup Then
        mnuTraceGroup.Checked = True
    ElseIf TraceLevel = sdaTraceLevelItem Then
        mnuTraceItem.Checked = True
    ElseIf TraceLevel = sdaTraceLevelAll Then
        mnuTraceAll.Checked = True
    End If
    
End Sub

'********************************************************************************
' Description:      Initialize the application.
'********************************************************************************
Private Sub Form_Load()

    Dim bExit As Boolean
    bExit = False
    
    On Error GoTo errHandler

    '
    ' Initialize the main form properties.
    '
    Me.Caption = App.Title
'    m_sAppDescription = "The " & App.Title & " is powered by Northern Dynamic's " & _
'        "Simple Language Independent Kit for developing OPC Data Access" & _
'        "servers (SLIK-DA).  Since SLIK-DA is delivered as an ActiveX " & _
'        "control, it can be utilized in virtually " & _
'        "any development environment, including VB, Delphi, Borland C++, " & _
'        "and Visual C++."
'    lblDescription.Caption = m_sAppDescription
    m_bForceExit = False
    
    m_sAppName = "Northern Dynamic's " & App.Title
    Me.Left = GetSetting(m_sAppName, "Settings", "MainLeft", 1000)
    Me.Top = GetSetting(m_sAppName, "Settings", "MainTop", 1000)
    Me.Width = GetSetting(m_sAppName, "Settings", "MainWidth", 9000)
    Me.Height = GetSetting(m_sAppName, "Settings", "MainHeight", 6000)
    
    Dim nTab As Long
    nTab = GetSetting(m_sAppName, "Settings", "TabSelected", 0)
    If nTab >= tabMain.Tabs Then
        nTab = tabMain.Tabs - 1
    ElseIf nTab < 0 Then
        nTab = 0
    End If
    tabMain.Tab = nTab
    
    ' Get the command line arguments to check for server registration switches
    Dim sCmdLine As String
    sCmdLine = Command()
    
    '
    ' NOTE: Do NOT prefix server registration switches with a forward slash "/".
    ' The VB runtime engine with NOT pass such arguments to the application.
    '
    'Call LogDebugMessage("Command line arguments: '" & sCmdLine & "'")
    
    '
    ' Perform server registration as required.
    '
    If InStr(1, sCmdLine, "unregserver", vbTextCompare) > 0 Then
        SLIKServer1.UnregisterServer
        bExit = True
    ElseIf InStr(1, sCmdLine, "regserver", vbTextCompare) > 0 Then
        SLIKServer1.RegisterServer
        bExit = True
    Else
        ' ignore any other switches
    End If
    
    If bExit Then
        ' If a server registration switch was specified in the command line, the
        ' standard COM server behaviour is to exit immediately after changing the
        ' registration information.
        m_bForceExit = True
        Unload Me
        Exit Sub
    End If
    
    '
    ' Initialize the security database
    '
    Dim i As Integer
    For i = 1 To 3
        m_SecDB(i).UserName = "User" + CStr(i)
        m_SecDB(i).Password = "pw" + CStr(i)
        If i = 1 Then
            m_SecDB(i).AccessGranted = sdaAGItemRead + sdaAGItemWrite
        ElseIf i = 2 Then
            m_SecDB(i).AccessGranted = sdaAGItemRead
        ElseIf i = 3 Then
            m_SecDB(i).AccessGranted = sdaAGItemWrite
        End If
    Next i
    
    '
    ' Start the server with the pre-defined namespace
    '
    If Not InitNamespace(SLIKServer1) Then
        m_bForceExit = True
        Unload Me
        Exit Sub
    End If
    SLIKServer1.StartServer
    
    '
    ' Initialize the statistics tab.
    '
    Call InitializeStatsView
    
    ' Start the periodic update of the statistics window.
    tmrMain.Enabled = True
    
    '
    ' Initialize the trace message logging.
    ' NOTE: For this sample application, always log trace message to the trace window.
    '
    Dim eTraceLevel As NDISLIKDACtl.TraceLevelEnum
    eTraceLevel = GetSetting(m_sAppName, "Settings", "TraceLevel", sdaTraceLevelNone)
    SLIKServer1.SetTraceInfo eTraceLevel, sdaTraceToEvent
    
    Call UpdateTraceOptions(eTraceLevel)
    
    Call LogDebugMessage("Server initialization completed.")

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Startup Error")
    m_bForceExit = True
    Unload Me
    Exit Sub

End Sub

'********************************************************************************
' Description:      Ensure that one of the following is true before exiting:
'                   1) No client connections to this server exist
'                   2) The user has selected the "Force Server Exit" option
'
' Parameters:
'   In:             UnloadMode  cause of the QueryUnload event
'   Out:            Cancel      if non-zero, do NOT proceed with exit
'
' Return Value:     None
'********************************************************************************
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    If (SLIKServer1.InUse) And (Not m_bForceExit) Then
        ' Cancel the shutdown
        Cancel = 1
        
        Dim sMsg As String
        sMsg = "The server is unable to shutdown at this time. " + _
            "There are still clients connected. " + _
            "If required, use the 'Force Server Exit' option."
        Call ReportEvent(sMsg, frmMain.Caption)
    End If
    
    ' Stop the periodic update of the statistics window.
    tmrMain.Enabled = True
    
    ' NOTE: When the SLIKServer object goes out of scope, it will clean up any
    '       remaining connections, groups, and items.

End Sub

'********************************************************************************
' Description:      Update the position and size of the controls on the main form.
'********************************************************************************
Private Sub Form_Resize()

    Dim iTabCtrlHeight As Integer
    Dim iTabPaneHeight As Integer
    Dim iDescrLblWidth As Integer
    
    If (WindowState = vbMinimized) Then
        'do nothing - to prevent scrunching controls
    Else
        AutoRedraw = True
        
        tabMain.Left = ScaleLeft
        fraDescription.Left = ScaleLeft
        
        tabMain.Width = ScaleWidth
        fraDescription.Width = ScaleWidth
        
        imgCert.Left = ScaleWidth - imgCert.Width - 120
        If (imgCert.Left <= (imgLogo.Left + imgLogo.Width)) Then
            imgCert.Visible = False
        Else
            imgCert.Visible = True
        End If
        
        iDescrLblWidth = imgCert.Left - (imgLogo.Left + imgLogo.Width) - 240
        If iDescrLblWidth > 0 Then
            lblDescription.Width = iDescrLblWidth
        Else
            lblDescription.Width = 0
        End If
        
        lvStats.Width = tabMain.Width - 100
        txtTraceMsgs.Width = tabMain.Width - 100
    
        iTabCtrlHeight = ScaleHeight - fraDescription.Height
        If iTabCtrlHeight > 0 Then
            tabMain.Top = ScaleTop
            tabMain.Height = iTabCtrlHeight
            fraDescription.Top = iTabCtrlHeight
            iTabPaneHeight = iTabCtrlHeight - tabMain.TabHeight - 120
            If iTabPaneHeight > 0 Then
                lvStats.Height = iTabPaneHeight
                txtTraceMsgs.Height = iTabPaneHeight
            End If
        Else
            tabMain.Height = 0
            fraDescription.Top = ScaleTop
        End If
        
        AutoRedraw = False
    End If
    
End Sub

'********************************************************************************
' Description:      Save the current user settings.
'********************************************************************************
Private Sub Form_Unload(Cancel As Integer)

    If Me.WindowState <> vbMinimized Then
        SaveSetting m_sAppName, "Settings", "MainLeft", Me.Left
        SaveSetting m_sAppName, "Settings", "MainTop", Me.Top
        SaveSetting m_sAppName, "Settings", "MainWidth", Me.Width
        SaveSetting m_sAppName, "Settings", "MainHeight", Me.Height
    End If
    
    Call SaveSetting(m_sAppName, "Settings", "TabSelected", tabMain.Tab)
    Call SaveSetting(m_sAppName, "Settings", "TraceLevel", SLIKServer1.TraceLevel)
    
End Sub

'********************************************************************************
' Description:      Display application and company information.
'********************************************************************************
Private Sub imgLogo_DblClick()

    frmAbout.Show vbModal, Me

End Sub

'********************************************************************************
' Description:      Modify the sample period (in milliseconds) that the toolkit
'                   will use while collecting time-based statistics (e.g. number
'                   of reads per period).
'********************************************************************************
Private Sub mnuEditStatPeriod_Click()

    On Error GoTo errHandler

    frmEditSP.m_nStatSamplePeriod = SLIKServer1.StatsSamplePeriod
    frmEditSP.Show vbModal, Me
    SLIKServer1.StatsSamplePeriod = frmEditSP.m_nStatSamplePeriod

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Statistics Period Update Error")

End Sub

'********************************************************************************
' Description:      Issues a request to all OPC clients to release all connections
'                   to this server.
'
'                   NOTE: Only V2.0 compliant clients would receive this request,
'                   as this functionality was introduced in version 2.0 of the OPC
'                   Data Access Standard.
'********************************************************************************
Private Sub mnuFileClientDisc_Click()

    On Error GoTo errHandler
    SLIKServer1.RequestDisconnect ("Server shutdown in 1 minute...")
    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Request Disconnect Error")

End Sub

'********************************************************************************
' Description:      Exit if no clients connections to this server exist.
'********************************************************************************
Private Sub mnuFileExit_Click()

    Unload Me

End Sub

'********************************************************************************
' Description:      Force this server to exit, even if clients are still connected.
'
'                   NOTE: Use of this feature may cause unpredictable behaviour in
'                   certain clients. Use with caution.
'********************************************************************************
Private Sub mnuFileForceExit_Click()

    m_bForceExit = True
    Unload Me

End Sub

'********************************************************************************
' Description:      Display application and company information.
'********************************************************************************
Private Sub mnuHelpAbout_Click()

    frmAbout.Show vbModal, Me

End Sub

'********************************************************************************
' Description:      Log all trace message types.
'********************************************************************************
Private Sub mnuTraceAll_Click()

    On Error GoTo errHandler

    ' update the SLIK server
    SLIKServer1.SetTraceInfo sdaTraceLevelAll
    
    ' update the main menu options
    Call UpdateTraceOptions(sdaTraceLevelAll)

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Trace Level Update Error")

End Sub

'********************************************************************************
' Description:      Log trace messages associated with client connectivity and
'                   server activation.
'********************************************************************************
Private Sub mnuTraceConnect_Click()

    On Error GoTo errHandler

    ' update the SLIK server
    SLIKServer1.SetTraceInfo sdaTraceLevelConnect
    
    ' update the main menu options
    Call UpdateTraceOptions(sdaTraceLevelConnect)

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Trace Level Update Error")

End Sub

'********************************************************************************
' Description:      Log trace messages associated with creating, deleting, or
'                   modifying OPC groups.
'********************************************************************************
Private Sub mnuTraceGroup_Click()

    On Error GoTo errHandler

    ' update the SLIK server
    SLIKServer1.SetTraceInfo sdaTraceLevelGroup
    
    ' update the main menu options
    Call UpdateTraceOptions(sdaTraceLevelGroup)

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Trace Level Update Error")

End Sub

'********************************************************************************
' Description:      Log trace messages associated with item transactions.
'                   For example, read, write, and subscription transactions.
'********************************************************************************
Private Sub mnuTraceItem_Click()

    On Error GoTo errHandler

    ' update the SLIK server
    SLIKServer1.SetTraceInfo sdaTraceLevelItem
    
    ' update the main menu options
    Call UpdateTraceOptions(sdaTraceLevelItem)

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Trace Level Update Error")

End Sub

'********************************************************************************
' Description:      Turn off internal SLIK server tracing.
'********************************************************************************
Private Sub mnuTraceNone_Click()

    On Error GoTo errHandler

    ' update the SLIK server
    SLIKServer1.SetTraceInfo sdaTraceLevelNone
    
    ' update the main menu options
    Call UpdateTraceOptions(sdaTraceLevelNone)

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Trace Level Update Error")

End Sub

'********************************************************************************
' Description:      Clear the contents of the trace message tab.
'********************************************************************************
Private Sub mnuTraceClear_Click()

    txtTraceMsgs.Text = ""

End Sub

'********************************************************************************
' Description:      Toggle logging of COM trace messages.
'********************************************************************************
Private Sub mnuTraceCOM_Click()

    On Error GoTo errHandler

    ' determine the new state
    mnuTraceCOM.Checked = Not mnuTraceCOM.Checked
    
    ' update the SLIK server
    SLIKServer1.COMCallTracingEnabled = mnuTraceCOM.Checked

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "COM Trace Toggle Error")

End Sub

'********************************************************************************
' Description:      OPC Private Security Enable / Disable.
'********************************************************************************
Private Sub mnuSecPriv_Click()
    On Error GoTo errHandler

    ' determine the new state
    mnuSecPriv.Checked = Not mnuSecPriv.Checked
    
    ' update the SLIK server
    SLIKServer1.SecurityPrivateEnabled = mnuSecPriv.Checked

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "Enable Private Security Toggle Error")
    
End Sub

'********************************************************************************
' Description:      This event is fired whenever an OPC client has requested a
'                   device read for one or more tags.
'
'                   NOTE: A handler should always be provided for this event!
'
' Parameters:
'   In:             Count       Number of items in the Tags array.
'                   Tags        Array of items to read.
'                   AccessPaths Array of requested access paths.
'                               Note: This server does not support access paths.
'   Out:            Errors      Array of item-level return codes.
'                       sdaSOK - The corresponding tag was read successfully.
'                               That tags value, quality, and timestamp was updated.
'                       sdaEFail - The read operation for the corresponding tag failed.
'
' Return Value:     sdaSOK      All tags were read successfully. Each tags value,
'                               quality, and timestamp was updated. All entries in
'                               the Errors array are sdaSOK.
'                   sdaSFalse   The operation succeeded, but one or more elements
'                               in the Errors array contains an error value.
'                   sdaEFail    The operation as a whole failed.
'********************************************************************************
Private Sub SLIKServer1_OnRead( _
    ByVal Count As Long, _
    Tags() As NDISLIKDACtl.ISLIKTag, _
    AccessPaths() As String, _
    Errors() As Long, _
    Result As Long _
)

    On Error GoTo errHandler
        
    Call ReadTags(Count, Tags, Errors, Result)
    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "OnRead Event Error")
    Result = sdaEFail

End Sub

'********************************************************************************
' Description:      This event is fired whenever an OPC client has issued a request
'                   to write new values to one or more tags.
'
'                   NOTE: A handler should always be provided for this event!
'
' Parameters:
'   In:             Count       Number of items in the Tags array.
'                   Tags        Array of items to write.
'                   AccessPaths Array of requested access paths.
'                               Note: This server does not support access paths.
'                   Values      Array of values to be written to each item.
'   Out:            Errors      Array of item-level return codes. Possible values
'                               for each element include:
'                       sdaSOK - The corresponding tag was written successfully.
'                               That tags value, quality, and timestamp was updated.
'                       sdaSClamp - The corresponding tag was written successfully,
'                               but was clamped.
'                       sdaERange - The value was out of range. It was not written
'                               to the tag.
'                       sdaEFail - The write operation for the corresponding tag failed.
'
' Return Value:     sdaSOK      All tags were written successfully. Each tags value,
'                               quality, and timestamp was updated. All entries in
'                               the Errors array are sdaSOK.
'                   sdaSFalse   The operation succeeded, but one or more elements
'                               in the Errors array contains an error value.
'                   sdaEFail    The operation as a whole failed.
'********************************************************************************
Private Sub SLIKServer1_OnWrite( _
    ByVal Count As Long, _
    Tags() As NDISLIKDACtl.ISLIKTag, _
    AccessPaths() As String, _
    Values() As Variant, _
    Errors() As Long, _
    Result As Long _
)
    On Error GoTo errHandler

    Call WriteTagValues(Count, Tags, Values, Errors, Result)
    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "OnWrite Event Error")
    Result = sdaEFail

End Sub

'********************************************************************************
' Description:      This event is fired whenever an OPC client has issued a request
'                   to write new values, qualities or timestamps to one or more tags.
'
' Parameters:
'   In:             Count       Number of items in the Tags array.
'                   Tags        Array of tags to write.
'                   AccessPaths Array of requested access paths.
'                               Note: This server does not support access paths.
'                   Values      Array of values to be written. If an
'                               entry contains an empty variant then a value is
'                               not to be written to the corresponding tag.
'                   Qualities   Array of qualities to be written. If an
'                               entry contains -1 then the quality is
'                               not to be written to the corresponding tag.
'                   Timestamps  Array of timestamps to be written. If an
'                               entry contains a 0 then a timestamp is
'                               not to be written to the corresponding tag.
'   Out:            Errors      Array of item-level return codes. Possible values
'                               for each element include:
'                       sdaSOK - The corresponding tag was written successfully.
'                               That tags value, quality, and timestamp was updated.
'                       sdaSClamp - The corresponding tag was written successfully,
'                               but was clamped.
'                       sdaERange - The value was out of range. It was not written
'                               to the tag.
'                       sdaEFail - The write operation for the corresponding tag failed.
'
' Return Value:     sdaSOK      All tags were written successfully. Each tags value,
'                               quality, and timestamp was updated. All entries in
'                               the Errors array are sdaSOK.
'                   sdaSFalse   The operation succeeded, but one or more elements
'                               in the Errors array contains an error value.
'                   sdaEFail    The operation as a whole failed.
'********************************************************************************
Private Sub SLIKServer1_OnWriteVQT( _
    ByVal Count As Long, _
    Tags() As NDISLIKDACtl.ISLIKTag, _
    AccessPaths() As String, _
    Values() As Variant, _
    Qualities() As Integer, _
    Timestamps() As Date, _
    ByRef Errors() As Long, _
    ByRef Result As Long _
)

    On Error GoTo errHandler

    Call WriteTagVQTs(Count, Tags, Values, Qualities, Timestamps, Errors, Result)
    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "OnWriteVQT Event Error")
    Result = sdaEFail

End Sub

'********************************************************************************
' Description:      This event is fired when OPC private security is enabled
'                   and a user is attempting to logon
'
' Parameters:
'   In:             UserName    -   User name to authenticate
'                   Password    -   Password to authenticate
'
'   Out:            UserSID     -   A unique, non-zero user security identifier
'
' Return Value:     sdaOK               The user credentials were authenticated
'                                       and a valid user security identifier is
'                                       returned
'                   sdaEAccessDenied    The credentials could be authenticated
'                   sdaEFail            The operation failed
'********************************************************************************
Private Sub SLIKServer1_OnAuthenticate( _
    ByVal UserName As String, _
    ByVal Password As String, _
    UserSID As Long, _
    Result As Long _
)
    On Error GoTo errHandler

    Result = sdaEAccessDenied
    Dim i As Integer
    For i = 1 To 3
        If (UserName = m_SecDB(i).UserName) And (Password = m_SecDB(i).Password) Then
            ' In this example the user security identifier is simply
            ' the index into the security database
            UserSID = i
            Result = sdaSOK
            Exit For
        End If
    Next i

    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "OnAuthenticate Event Error")
    Result = sdaEFail

End Sub

'********************************************************************************
' Description:      This event is fired, when OPC private security is enabled,
'                   to get the access permissions granted to a given user.
'
' Parameters:
'   In:             UserSID         -   A unique user securuty identifier
'                                       returned from a previous OnAuthenticate
'                                       event
'                   TagName         -   The tag name for which to retrieve the
'                                       access permissions granted to the user.
'                                       If server level security granularity is
'                                       selected this parameter will contain
'                                       an empty string
'
'   Out:            AccessGranted   -   The access permissions granted to the
'                                       user.  This should contain a combination
'                                       of the values defined by the
'                                       AccessGrantedEnum enumeration.
'
' Return Value:     sdaSOK
'                   sdaEInvalidArg
'                   sdaEFail
'********************************************************************************
Private Sub SLIKServer1_OnAccessCheck( _
    ByVal UserSID As Long, _
    ByVal TagName As String, _
    AccessGranted As Long, _
    Result As Long _
)
    On Error GoTo errHandler

    '
    '   This example uses Server level security granularity.  As such,
    '   the granted access permissions returned here will apply to all tags
    '   the user might access.
    '
    If (UserSID <= 3) Then
        AccessGranted = m_SecDB(UserSID).AccessGranted
        Result = sdaSOK
    Else
        Result = sdaEInvalidArg
    End If
    
    Exit Sub

errHandler:
    Call ReportEvent(Err.Description, "OnAccessCheck Event Error")
    Result = sdaEFail
    
End Sub

'********************************************************************************
' Description:      This event is fired when the SLIK server is outputting a trace
'                   message, if and only if the trace destination was set to
'                   sdaTraceToEvent via the SetTraceInfo() method.
'
' Parameters:
'   In:             TraceMessage  The trace message string.
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub SLIKServer1_OnTrace(ByVal TraceMessage As String)

    ' Remove the trailing newline character
    TraceMessage = Mid(TraceMessage, 1, Len(TraceMessage) - 1)
    
    Call LogTraceMessage(TraceMessage)

End Sub

'********************************************************************************
' Description:      Periodic timer to update the server statistics view.
'
' Parameters:
'   In:             None
'
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub tmrMain_Timer()

    Call UpdateStatsView

End Sub

'********************************************************************************
' Description:      Periodic timer to update the tags.
'
' Parameters:
'   In:             None
'
'   Out:            None
'
' Return Value:     None
'********************************************************************************
Private Sub tmrTagUpdate_Timer()
    
    If tmrTagUpdate.Enabled = False Then Exit Sub
    tmrTagUpdate.Enabled = False
    
    Call UpdateTags(SLIKServer1.SLIKTags)
    
    tmrTagUpdate.Enabled = True
    
End Sub
